WrappedStyledStringStamp = function(canvas, rect, styledString, paint, halign, valign)
    if styledString then
        halign = halign or 0
        valign = valign or 0
        local lineStrings = styledString:wrap(rect:width())
        local totalHeight = 0
        local stringRects = {}
        for index = 1, #lineStrings do
            local stringRect = lineStrings[index]:measure()
            stringRects[index] = stringRect
            totalHeight = totalHeight + stringRect:height()
        end
        canvas:setPaint(paint)
        local lineOffset = 0
        for index = 1, #lineStrings do
            local lineString = lineStrings[index]
            local stringRect = stringRects[index]
            lineOffset = lineOffset + stringRect:height()
            canvas:drawText(lineString,
                rect.left + halign * (rect:width() - stringRect:width()) - stringRect:minx(),
                rect.bottom + valign * (rect:height() - totalHeight) + totalHeight - lineOffset - stringRect:miny())
        end
    end
end

return WrappedStyledStringStamp
